/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.editor;

import dev.lucaargolo.charta.utils.CardImage;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class ToolPanel
extends JPanel {
    private int selectedLeftIndex = 0;
    private int selectedRightIndex = 0;
    private final JSlider alphaSlider;
    private final JLabel leftColorLabel;
    private final JLabel rightColorLabel;
    private final JCheckBox glowCheckbox;
    private final JCheckBox pencilCheckbox;
    private final JCheckBox eraserCheckbox;
    private final JCheckBox fillCheckbox;

    public ToolPanel() {
        this.setLayout(new BorderLayout());
        JPanel colorPanel = new JPanel(new GridLayout(8, 8));
        for (int i = 0; i < CardImage.COLOR_PALETTE.length; ++i) {
            JButton colorButton = this.getColorButton(i);
            colorPanel.add(colorButton);
        }
        JPanel transparencyPanel = new JPanel(new BorderLayout());
        this.alphaSlider = new JSlider(1, 3);
        this.alphaSlider.setMajorTickSpacing(1);
        this.alphaSlider.setPaintTicks(true);
        this.alphaSlider.setPaintLabels(true);
        this.alphaSlider.setSnapToTicks(true);
        this.alphaSlider.setLabelTable(this.alphaSlider.createStandardLabels(1));
        this.alphaSlider.setValue(4);
        transparencyPanel.add((Component)new JLabel("Alpha Level"), "North");
        transparencyPanel.add((Component)this.alphaSlider, "Center");
        this.glowCheckbox = new JCheckBox("Glow");
        this.glowCheckbox.setSelected(false);
        transparencyPanel.add((Component)this.glowCheckbox, "South");
        this.glowCheckbox.addChangeListener(e -> this.alphaSlider.setEnabled(!this.glowCheckbox.isSelected()));
        this.leftColorLabel = new JLabel();
        this.leftColorLabel.setOpaque(true);
        this.leftColorLabel.setBorder(BorderFactory.createLineBorder(Color.GRAY, 2));
        this.leftColorLabel.setBackground(new Color(CardImage.COLOR_PALETTE[this.selectedLeftIndex]));
        this.leftColorLabel.setPreferredSize(new Dimension(25, 25));
        this.rightColorLabel = new JLabel();
        this.rightColorLabel.setOpaque(true);
        this.rightColorLabel.setBorder(BorderFactory.createLineBorder(Color.GRAY, 2));
        this.rightColorLabel.setBackground(new Color(CardImage.COLOR_PALETTE[this.selectedRightIndex]));
        this.rightColorLabel.setPreferredSize(new Dimension(25, 25));
        JPanel leftVisualizingPanel = new JPanel(new BorderLayout());
        leftVisualizingPanel.add((Component)new JLabel("Left"), "North");
        leftVisualizingPanel.add((Component)new JLabel("Right"), "Center");
        this.pencilCheckbox = new JCheckBox("Pencil");
        this.pencilCheckbox.setSelected(true);
        leftVisualizingPanel.add((Component)this.pencilCheckbox, "South");
        JPanel centerVisualizingPanel = new JPanel(new BorderLayout());
        this.eraserCheckbox = new JCheckBox("Eraser");
        this.eraserCheckbox.setSelected(false);
        centerVisualizingPanel.add((Component)this.eraserCheckbox, "South");
        JPanel rightVisualizingPanel = new JPanel(new BorderLayout());
        rightVisualizingPanel.add((Component)this.leftColorLabel, "North");
        rightVisualizingPanel.add((Component)this.rightColorLabel, "Center");
        this.fillCheckbox = new JCheckBox("Fill");
        this.fillCheckbox.setSelected(false);
        rightVisualizingPanel.add((Component)this.fillCheckbox, "South");
        this.pencilCheckbox.addChangeListener(e -> {
            if (this.pencilCheckbox.isSelected()) {
                this.eraserCheckbox.setSelected(false);
                this.fillCheckbox.setSelected(false);
            }
        });
        this.eraserCheckbox.addChangeListener(e -> {
            if (this.eraserCheckbox.isSelected()) {
                this.pencilCheckbox.setSelected(false);
                this.fillCheckbox.setSelected(false);
            }
        });
        this.fillCheckbox.addChangeListener(e -> {
            if (this.fillCheckbox.isSelected()) {
                this.pencilCheckbox.setSelected(false);
                this.eraserCheckbox.setSelected(false);
            }
        });
        JPanel visualizingPanel = new JPanel(new BorderLayout());
        visualizingPanel.add((Component)leftVisualizingPanel, "West");
        visualizingPanel.add((Component)centerVisualizingPanel, "Center");
        visualizingPanel.add((Component)rightVisualizingPanel, "East");
        this.add((Component)colorPanel, "Center");
        this.add((Component)visualizingPanel, "West");
        this.add((Component)transparencyPanel, "East");
    }

    @NotNull
    private JButton getColorButton(final int i) {
        Color color = new Color(CardImage.COLOR_PALETTE[i]);
        JButton colorButton = new JButton();
        colorButton.setBackground(color);
        colorButton.setOpaque(true);
        colorButton.setBorderPainted(true);
        colorButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    ToolPanel.this.selectedLeftIndex = i;
                    ToolPanel.this.leftColorLabel.setBackground(new Color(CardImage.COLOR_PALETTE[ToolPanel.this.selectedLeftIndex]));
                } else if (SwingUtilities.isRightMouseButton(e)) {
                    ToolPanel.this.selectedRightIndex = i;
                    ToolPanel.this.rightColorLabel.setBackground(new Color(CardImage.COLOR_PALETTE[ToolPanel.this.selectedRightIndex]));
                }
            }
        });
        return colorButton;
    }

    public int getLeftIndex() {
        return this.selectedLeftIndex;
    }

    public int getRightIndex() {
        return this.selectedRightIndex;
    }

    public int getAlphaIndex() {
        return this.glowCheckbox.isSelected() ? 0 : this.alphaSlider.getValue();
    }

    public boolean isErasing() {
        return this.eraserCheckbox.isSelected();
    }

    public boolean isFilling() {
        return this.fillCheckbox.isSelected();
    }
}

